/*** CONFIDENTIAL ***/
/* Copyright (C) 2011 2012 2013, Panasonic Corporation */
#ifndef __FUSION__CALL_H__
#define __FUSION__CALL_H__

#include <linux/fusion.h>

#include "fusiondev.h"

int  fusion_call_init   (FusionDev *dev);
void fusion_call_deinit (FusionDev *dev);


int fusion_call_new     (FusionDev         *dev,
                         int                fusion_id,
                         FusionCallNew     *call);

int fusion_call_execute (FusionDev         *dev,
                         Fusionee          *fusionee, 
                         FusionCallExecute *execute);

int fusion_call_return  (FusionDev         *dev,
                         int                fusion_id,
                         FusionCallReturn  *call_ret);

int fusion_call_destroy (FusionDev         *dev,
                         int                fusion_id,
                         int                call_id);


void fusion_call_destroy_all (FusionDev *dev,
                              int        fusion_id);

#endif
